#include <stdio.h>
#include <string.h>

#define NLETS	12
int nlet[NLETS] = {1, 1, 1, 1, 2, 3, 4, 5, 7, 0xc, 0xc, 0x33};

char sumdigs(char* str)
{
	char buf[20];

	int i = 0, n = 0;

	while (str[i] != '\0')
		n += str[i++] - '0';

	if (n > 9) {
		sprintf(buf, "%d", n);
		return sumdigs(buf);
	} else
		return n + '0';
}

void makecode(char* name, char* comp, char* regcode)
{
	char nmix[200];
	char rc[20];
	char buf[300];
	int ln, lc;
	int i, in, ic;

	strupr(name);
	strupr(comp);
	ln = strlen(name);
	lc = strlen(comp);

	ic = (lc & 0xfffe) - 1;
	in = 0;
	i = 0;
	while (ic > 0 || in < ln) {
		if (ic > 0) {
			nmix[i] = comp[ic];
			ic -= 2;
			i++;
		}
		if (in < ln) {
			nmix[i] = name[in];
			in += 2;
			i++;
		}
	}
	ic = 0;
	in = (ln & 0xfffe) - 1;
	while (ic < lc || in > 0) {
		if (in > 0) {
			nmix[i] = name[in];
			in -= 2;
			i++;
		}
		if (ic < lc) {
			nmix[i] = comp[ic];
			ic += 2;
			i++;
		}
	}
	for (i; i < 100; i++)
		nmix[i] = ' ';
	nmix[100] = '\0';

	ic = 0;
	for (i=0; i < NLETS; i++) {
		for (in=0; in < nlet[i]; in++, ic++)
			sprintf(buf + in*2, "%d", nmix[ic]);
		rc[i] = sumdigs(buf);
	}
	rc[i] = '\0';
	rc[i] = sumdigs(rc);
	strncpy(regcode, rc, 4);
	regcode[4] = '-';
	strncpy(regcode+5, rc+4, 4);
	regcode[9] = '-';
	strncpy(regcode+10, rc+8, 5);
	regcode[15] = '\0';
}

void main()
{
	char name[200], comp[200], regcode[20];

	printf("BowerBird v1.01 Registration Code generator (fOSSiL 1998)\n\n");
	printf("Name     : ");
	gets(name);
	printf("Company  : ");
	gets(comp);
	if (strlen(name) + strlen(comp) < 8) {
		printf("\nOops! Name and Company together have to be at least 8 chars\n");
		exit(1);
	}
	makecode(name, comp, regcode);
	printf("Reg Code : %s\n", regcode);
}